﻿using System;
using System.Linq;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using Microsoft.WindowsMobile.Status;

namespace StanUrzadzeniaPrzenosnego
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();

            Refresh();
        }

        static string JestBrak(bool wartoscLogiczna)
        {
            return wartoscLogiczna?"Jest":"Brak";
        }

        static string TakNie(bool wartoscLogiczna)
        {
            return wartoscLogiczna?"Tak":"Nie";
        }

        string[] pobierzInformacjeOStanieUrzadzenia()
        {
            List<string> lista = new List<string>();
            lista.Add("Stan urządzenia (" + SystemState.Time.ToString() + "):");
            lista.Add("Właściciel: " + SystemState.OwnerName);
            lista.Add("");

            lista.Add("Orientacja urządzenia: " + SystemState.DisplayRotation.ToString());
            lista.Add("Urządzenie zablokowane: " + TakNie(SystemState.DeviceLocked));
            lista.Add("");

            lista.Add("Ilość nieprzeczytanych wiadomości SMS: " + SystemState.MessagingSmsUnread.ToString());
            lista.Add("Ilość nieprzeczytanych listów e-mail: " + SystemState.MessagingTotalEmailUnread.ToString());
            lista.Add("");

            lista.Add("Karta WiFi: " + JestBrak(SystemState.WiFiStateHardwarePresent));
            lista.Add("WiFi wlaczone: " + TakNie(SystemState.WiFiStatePowerOn));
            lista.Add("Połączenie WiFi: " + TakNie(SystemState.WiFiStateConnected));
            lista.Add("");

            lista.Add("Aparat fotograficzny: " + JestBrak(SystemState.CameraPresent));
            lista.Add("Aparat zablokowany: " + TakNie(!SystemState.CameraEnabled));

            return lista.ToArray();
        }

        public override void Refresh()
        {
            base.Refresh();

            try
            {
                listBox1.Items.Clear();
                string[] wlasnosci = pobierzInformacjeOStanieUrzadzenia();
                foreach (string wlasnosc in wlasnosci)
                    listBox1.Items.Add(wlasnosc);
            }
            catch (Exception exc)
            {
                MessageBox.Show("Błąd przy odczycie stanu urządzenia!\n"+exc.Message);
            }
        }

        private void menuItem1_Click(object sender, EventArgs e)
        {
            Refresh();
        }

        private void menuItem2_Click(object sender, EventArgs e)
        {
            Close();
        }
    }
}